/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.compatibility.createextendedcogs;

import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileInstance;
import com.simibubi.create.content.contraptions.base.flwdata.RotatingData;
import com.simibubi.create.foundation.utility.Iterate;
import fr.iglee42.createcasing.compatibility.createextendedcogs.CustomCogwheelCompat;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class EncasedCogWheelTileInstanceCompat
extends KineticTileInstance<KineticTileEntity> {
    protected RotatingData rotatingModel;
    protected Optional<RotatingData> rotatingTopShaft;
    protected Optional<RotatingData> rotatingBottomShaft;

    public EncasedCogWheelTileInstanceCompat(MaterialManager modelManager, KineticTileEntity tile) {
        super(modelManager, tile);
    }

    public void init() {
        this.rotatingModel = this.setup((RotatingData)this.getCogModel().createInstance());
        Block block = this.blockState.m_60734_();
        if (block instanceof IRotate) {
            IRotate def = (IRotate)block;
            this.rotatingTopShaft = Optional.empty();
            this.rotatingBottomShaft = Optional.empty();
            for (Direction d : Iterate.directionsInAxis((Direction.Axis)this.axis)) {
                if (!def.hasShaftTowards((LevelReader)((KineticTileEntity)this.blockEntity).m_58904_(), ((KineticTileEntity)this.blockEntity).m_58899_(), this.blockState, d)) continue;
                RotatingData data = this.setup((RotatingData)this.getRotatingMaterial().getModel(AllBlockPartials.SHAFT_HALF, this.blockState, d).createInstance());
                if (d.m_122421_() == Direction.AxisDirection.POSITIVE) {
                    this.rotatingTopShaft = Optional.of(data);
                    continue;
                }
                this.rotatingBottomShaft = Optional.of(data);
            }
        }
    }

    public void update() {
        this.updateRotation(this.rotatingModel);
        this.rotatingTopShaft.ifPresent(x$0 -> this.updateRotation((RotatingData)x$0));
        this.rotatingBottomShaft.ifPresent(x$0 -> this.updateRotation((RotatingData)x$0));
    }

    public void updateLight() {
        this.relight(this.pos, new FlatLit[]{this.rotatingModel});
        this.rotatingTopShaft.ifPresent(d -> this.relight(this.pos, new FlatLit[]{d}));
        this.rotatingBottomShaft.ifPresent(d -> this.relight(this.pos, new FlatLit[]{d}));
    }

    public void remove() {
        this.rotatingModel.delete();
        this.rotatingTopShaft.ifPresent(InstanceData::delete);
        this.rotatingBottomShaft.ifPresent(InstanceData::delete);
    }

    protected Instancer<RotatingData> getCogModel() {
        BlockState referenceState = ((KineticTileEntity)this.blockEntity).m_58900_();
        Direction facing = Direction.m_122387_((Direction.Axis)((Direction.Axis)referenceState.m_61143_((Property)BlockStateProperties.f_61365_)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        PartialModel partial = ((CustomCogwheelCompat)referenceState.m_60734_()).getPartialModelType();
        if (partial == null) {
            partial = AllBlockPartials.SHAFTLESS_COGWHEEL;
        }
        return this.getRotatingMaterial().getModel(partial, referenceState, facing, () -> {
            PoseStack poseStack = new PoseStack();
            ((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((PoseStack)poseStack).centre()).rotateToFace(facing)).multiply(Vector3f.f_122222_.m_122240_(90.0f))).unCentre();
            return poseStack;
        });
    }
}

